$(document).ready(function(){
    
    $('.flexslider').flexslider({
        animation: "slide"
    });
    
    $('#back-to-top').each(function () {

        var $this = $(this);

        $this.on('click', function (event) {
            event.preventDefault();
            $('html, body').animate({ scrollTop: 0 }, 500);
        });

        $(window).scroll(function () {
            if ($(this).scrollTop() > 300) {
                $this.fadeIn(200);
            } else if ($(this).scrollTop() < 250) {
                $this.fadeOut(200);
            }
        });

    });
    
    $("button.reset").on("click", function(){
        setTimeout(function(){clear_func();},500);
    });
    
    function clear_func()
    {
        $("input[type=text]").each(function(){
            $(this).val("");
        });
        $("input[type=email]").each(function(){
            $(this).val("");
        });
        $("textarea").each(function(){
            $(this).val("");
        });
        $("select").each(function(){
            $(this).val("");
        });
    }
    
    $(window).scroll(function () {
        if ($(this).scrollTop() > 300) {
            $("header").addClass("fixed_header");
        } else if ($(this).scrollTop() < 250) {
            $("header").removeClass("fixed_header");
        }
    });
    
    $("section#contacts .left_contacts .contact_form form").form({
        fields:[
            ['name','name'],
            ['city','text'],
            ['phone','text'],
            ['email','email'],
            ['message','text']
        ],
        submit: 'section#contacts .left_contacts .contact_form .btn_block span'
    });
    

    $("input[name='pickup_from'], input[name='final_from']").on("change", function(){
        var id=$(this).attr("data-id");
        $(this).parent().parent().find(".hidden_radio").hide();
        $(this).parent().parent().find(".hidden_"+id).show("slow");
    })
    
    $("#reserve_block #form_res_1").validate({
        rules: {
            f_name: "required",
            l_name: "required",
            address_1: "required",
            country: "required",
            city: "required",
            daytime_phone: "required",
            email: {
                required: true,
                email: true
            }
        }
    });
    

    
    $("#reserve_block #form_res_3").validate({
        rules: {
            cardtype: "required",
            cardnumber: {
                required: true,
                minlength: function() {
                    $result = 16;
                    f_letter=$('#c_number').val();
                    f_letter=f_letter.toString().substr(0, 1);
                    if (f_letter=='3') {
                        $result=15;
                    }
                    return $result;
                },
                maxlength: function() {
                    $result = 16;
                    f_letter=$('#c_number').val();
                    f_letter=f_letter.toString().substr(0, 1);
                    if (f_letter=='3') {
                        $result=15;
                    }
                    return $result;
                }
            },
            expdatemonth: "required",
            expdateyear: "required",
            cv2code: {
                required: true,
                minlength: function() {
                    $result = 3;
                    f_letter=$('#c_number').val();
                    f_letter=f_letter.toString().substr(0, 1);
                    if (f_letter=='3') {
                        $result=4;
                    }
                    return $result;
                }
            },
            agree: "required",
            nameofcard: "required"
        },
        messages: {
            agree: {
                required: "You must accept the Terms & Conditions to proceed."
            }
        }
    });
    
    $("#usefrompickup").on("change", function(){
        if ($(this).is(":checked"))
        {
            $("input[name=d_location_name]").val($("input[name=p_location_name]").val());
            $("input[name=d_address]").val($("input[name=p_address]").val());
            $("input[name=d_address_2]").val($("input[name=p_address_2]").val());
            $("input[name=d_city]").val($("input[name=p_city]").val());
            $("input[name=d_zip]").val($("input[name=p_zip]").val());
            $("textarea[name=d_comments]").val($("textarea[name=p_comments]").val());
            $("select[name=d_county]").val($("select[name=p_county]").val());

            if ($("select[name=p_county]").val()=='Canada')
            {
                state='<select name="d_state" style="width: 100%;">\
                        <option value="">Please select</option>\
                        <option value="Alberta">Alberta</option>\
                        <option value="British Columbia">British Columbia</option>\
                        <option value="Manitoba">Manitoba</option>\
                        <option value="Ontario">Ontario</option>\
                        <option value="Quebec">Quebec</option>\
                        <option value="Saskatchewan">Saskatchewan</option>\
                        </select>';

            }
            else
            {
                state='<select name="d_state" style="width:100%;">\
                        <option value="">Please select</option>\
                    <option value="AL">Alabama</option>\
                    <option value="AK">Alaska</option>\
                    <option value="AZ">Arizona</option>\
                    <option value="AR">Arkansas</option>\
                    <option value="CA">California</option>\
                    <option value="CO">Colorado</option>\
                    <option value="CT">Connecticut</option>\
                    <option value="DE">Delaware</option>\
                    <option value="DC">District Of Columbia</option>\
                    <option value="FL">Florida</option>\
                    <option value="GA">Georgia</option>\
                    <option value="HI">Hawaii</option>\
                    <option value="ID">Idaho</option>\
                    <option value="IL">Illinois</option>\
                    <option value="IN">Indiana</option>\
                    <option value="IA">Iowa</option>\
                    <option value="KS">Kansas</option>\
                    <option value="KY">Kentucky</option>\
                    <option value="LA">Louisiana</option>\
                    <option value="ME">Maine</option>\
                    <option value="MD">Maryland</option>\
                    <option value="MA">Massachusetts</option>\
                    <option value="MI">Michigan</option>\
                    <option value="MN">Minnesota</option>\
                    <option value="MS">Mississippi</option>\
                    <option value="MO">Missouri</option>\
                    <option value="MT">Montana</option>\
                    <option value="NE">Nebraska</option>\
                    <option value="NV">Nevada</option>\
                    <option value="NH">New Hampshire</option>\
                    <option value="NJ">New Jersey</option>\
                    <option value="NM">New Mexico</option>\
                    <option value="NY">New York</option>\
                    <option value="NC">North Carolina</option>\
                    <option value="ND">North Dakota</option>\
                    <option value="OH">Ohio</option>\
                    <option value="OK">Oklahoma</option>\
                    <option value="OR">Oregon</option>\
                    <option value="PA">Pennsylvania</option>\
                    <option value="RI">Rhode Island</option>\
                    <option value="SC">South Carolina</option>\
                    <option value="SD">South Dakota</option>\
                    <option value="TN">Tennessee</option>\
                    <option value="TX">Texas</option>\
                    <option value="UT">Utah</option>\
                    <option value="VT">Vermont</option>\
                    <option value="VA">Virginia</option>\
                    <option value="WA">Washington</option>\
                    <option value="WV">West Virginia</option>\
                    <option value="WI">Wisconsin</option>\
                    <option value="WY">Wyoming</option>\
                    </select>';
            }


            $('#state_sel_2 select').val('');
            $('#state_sel_2').html(state);

            $("select[name=d_state]").val($("select[name=p_state]").val());
        }
    });
    
    $(".fancy").fancybox();
    
    
    
    
    $("#res_main").form({
        fields:[
            ['name','name'],
            ['phone','phone'],
            ['email','email'],
            ['pickup_date','text'],
            ['vehicle','text']
        ],
        submit: '.ri_button'
    });

    // date
    var timeAr=[],
        t=0,
        m=-5,
        h=12,
        dt='';
        while (t<2)
        {
            t++;
            if (t==1) dt='AM';
            else dt='PM';
            h=12;
            while (h<11 || h==12)
            {
                h++;
                if (h==13) h=12;

                m=0;
                while (m<55)
                {
                    m=m+15;
                    if (m<10) md='0'+m; else md=m
                    timeAr.push(h+':'+md+' '+dt);
                }

                if (h==12) h=0;
            }
        }

    $('.datepicker').datetimepicker({
        timepicker:true,
        format: 'm/d/Y g:i A',
        minDate: 0,
        formatTime: 'g:i A',
        allowTimes:timeAr
    });
    $('.calendar').click(function(){
        $(this).parent().find('.datepicker').focus();
    });
    
    $(".phone_header .menu_section .menu_img img").on("click", function(){
        $(".phone_header .menu_section .phone_menu_block .open_close_menu").toggle("slow");
    });
    
    $(".rates_tab .checkbox-block input").on("change", function(){
        var id=$(this).attr("data-id");
        $(".rates_tab_content").hide();
        $("#rates_c_"+id).show();
    }); 
    
    
});