<?php

namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\TemplateRequest as StoreRequest;
use App\Http\Requests\TemplateRequest as UpdateRequest;

class TemplateCrudController extends CrudController
{

	public function setUp()
    {

        /*
		|--------------------------------------------------------------------------
		| BASIC CRUD INFORMATION
		|--------------------------------------------------------------------------
		*/
        $this->crud->setModel("App\Models\Template");
        $this->crud->setRoute("admin/template");
        $this->crud->setEntityNameStrings('template', 'templates');
		$this->crud->enableDetailsRow();
		$this->crud->allowAccess('details_row');
		$this->crud->setDetailsRowView('template.details_row');

        /*
		|--------------------------------------------------------------------------
		| BASIC CRUD INFORMATION
		|--------------------------------------------------------------------------
		*/

        $this->crud->setFromDb();

        // ------ CRUD FIELDS
        // $this->crud->addField($options, 'update/create/both');
        // $this->crud->addFields($array_of_arrays, 'update/create/both');
        // $this->crud->removeField('name', 'update/create/both');
        // $this->crud->removeFields($array_of_names, 'update/create/both');
		
		$this->crud->addField([
			'name' => 'subtitle',
			'label' => 'Subtitle',
			'type' => 'text',
		 ]);
		$this->crud->addField([
			'name' => 'demo',
			'label' => 'Link to demo page',
			'type' => 'text',
		 ]);
		$this->crud->addField([
			'name' => 'download',
			'label' => 'Link to downloadable archive',
			'type' => 'text',
		 ]);
		$this->crud->addField([	// Image
			'name' => 'preview',
			'label' => 'Preview',
			'type' => 'image'
		]);
		$this->crud->addField([	// Image
			'name' => 'preview_mobile',
			'label' => 'Preview Mobile',
			'type' => 'image'
		]);
		$this->crud->addField([	// Image
			'name' => 'bg',
			'label' => 'Background for previews',
			'type' => 'image'
		]);
		$this->crud->addField([	// Image
			'name' => 'img',
			'label' => 'Big Screenshot',
			'type' => 'image'
		]);
		$this->crud->addField([	// Select2Multiple = n-n
			'label' => 'Tags',
			'type' => 'select2_multiple',
			'name' => 'tags',
			'entity' => 'tags',
			'attribute' => 'name',
			'model' => "App\Models\Tag",
			'pivot' => true,
		]);
		$this->crud->addField([	// Select2Multiple = n-n
			'label' => 'Requirements',
			'type' => 'select2_multiple',
			'name' => 'requirements',
			'entity' => 'requirements',
			'attribute' => 'name',
			'model' => "App\Models\Requirement",
			'pivot' => true,
		]);
		
		$this->crud->addField([
			'name' => 'price',
			'label' => 'Price',
			'type' => 'number',
			'prefix' => "$",
			'suffix' => ".00",
		 ]);
		$this->crud->addField([
			'name' => 'price_installation',
			'label' => 'Instalation Template',
			'type' => 'number',
			'prefix' => "$",
			'suffix' => ".00",
		 ]);
		$this->crud->addField([
			'name' => 'price_logo',
			'label' => 'Price Integration of your logo',
			'type' => 'number',
			'prefix' => "$",
			'suffix' => ".00",
		 ]);
		$this->crud->addField([
			'name' => 'price_psd',
			'label' => 'Price PSD',
			'type' => 'number',
			'prefix' => "$",
			'suffix' => ".00",
		 ]);
		$this->crud->addField([
			'name' => 'price_hosting',
			'label' => 'Price Install Hosting',
			'type' => 'number',
			'prefix' => "$",
			'suffix' => ".00",
		 ]);
		$this->crud->addField([
				'name' => 'priority',
				'label' => 'Priority',
				'type' => 'number',
				'default' => 0
			]
		);

        // ------ CRUD COLUMNS
		$this->crud->setColumnDetails('preview', [
				// run a function on the CRUD model and show its return value
				'label' => "Preview", // Table column heading
				'type' => "model_function",
				'function_name' => 'getPreview', // the method in your Model
		]);

		$this->crud->setColumnDetails('demo', [
			'label' => 'Demo link',
			'type' => "model_function",
			'function_name' => 'getDemoLink', // the method in your Model
		]);
		$this->crud->setColumnDetails('download', [
			'label' => 'Download link',
			'type' => "model_function",
			'function_name' => 'getDownloadLink', // the method in your Model
		]);

		
		$this->crud->removeColumn('text');
		$this->crud->removeColumn('preview_mobile');
		$this->crud->removeColumn('bg');
		$this->crud->removeColumn('img');
		$this->crud->setColumnDetails('price_installation', ['label' => 'Installation']); // adjusts the properties of the passed in column (by name)
		$this->crud->setColumnDetails('price_logo', ['label' => 'Logo']); // adjusts the properties of the passed in column (by name)
		$this->crud->setColumnDetails('price_psd', ['label' => 'PSD']); // adjusts the properties of the passed in column (by name)
		$this->crud->setColumnDetails('price_hosting', ['label' => 'Hosting']); // adjusts the properties of the passed in column (by name)

        // $this->crud->addColumn(); // add a single column, at the end of the stack
        // $this->crud->addColumns(); // add multiple columns, at the end of the stack
        // $this->crud->removeColumn('column_name'); // remove a column from the stack
        // $this->crud->removeColumns(['column_name_1', 'column_name_2']); // remove an array of columns from the stack
        // $this->crud->setColumnDetails('column_name', ['attribute' => 'value']); // adjusts the properties of the passed in column (by name)
        // $this->crud->setColumnsDetails(['column_1', 'column_2'], ['attribute' => 'value']);

        // ------ CRUD BUTTONS
        // possible positions: 'beginning' and 'end'; defaults to 'beginning' for the 'line' stack, 'end' for the others;
        // $this->crud->addButton($stack, $name, $type, $content, $position); // add a button; possible types are: view, model_function
        // $this->crud->addButtonFromModelFunction($stack, $name, $model_function_name, $position); // add a button whose HTML is returned by a method in the CRUD model
        // $this->crud->addButtonFromView($stack, $name, $view, $position); // add a button whose HTML is in a view placed at resources\views\vendor\backpack\crud\buttons
        // $this->crud->removeButton($name);
        // $this->crud->removeButtonFromStack($name, $stack);

        // ------ CRUD ACCESS
        // $this->crud->allowAccess(['list', 'create', 'update', 'reorder', 'delete']);
        // $this->crud->denyAccess(['list', 'create', 'update', 'reorder', 'delete']);

        // ------ CRUD REORDER
        // $this->crud->enableReorder('label_name', MAX_TREE_LEVEL);
        // NOTE: you also need to do allow access to the right users: $this->crud->allowAccess('reorder');

        // ------ CRUD DETAILS ROW
        // $this->crud->enableDetailsRow();
        // NOTE: you also need to do allow access to the right users: $this->crud->allowAccess('details_row');
        // NOTE: you also need to do overwrite the showDetailsRow($id) method in your EntityCrudController to show whatever you'd like in the details row OR overwrite the views/backpack/crud/details_row.blade.php

        // ------ REVISIONS
        // You also need to use \Venturecraft\Revisionable\RevisionableTrait;
        // Please check out: https://laravel-backpack.readme.io/docs/crud#revisions
        // $this->crud->allowAccess('revisions');

        // ------ AJAX TABLE VIEW
        // Please note the drawbacks of this though:
        // - 1-n and n-n columns are not searchable
        // - date and datetime columns won't be sortable anymore
        // $this->crud->enableAjaxTable();

        // ------ DATATABLE EXPORT BUTTONS
        // Show export to PDF, CSV, XLS and Print buttons on the table view.
        // Does not work well with AJAX datatables.
        // $this->crud->enableExportButtons();

        // ------ ADVANCED QUERIES
        // $this->crud->addClause('active');
        // $this->crud->addClause('type', 'car');
        // $this->crud->addClause('where', 'name', '==', 'car');
        // $this->crud->addClause('whereName', 'car');
        // $this->crud->addClause('whereHas', 'posts', function($query) {
        //     $query->activePosts();
        // });
        // $this->crud->with(); // eager load relationships
         $this->crud->orderBy('priority', 'desc');
        // $this->crud->groupBy();
        // $this->crud->limit();
    }

	public function store(StoreRequest $request)
	{
		// your additional operations before save here
        $redirect_location = parent::storeCrud();
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
	}

	public function update(UpdateRequest $request)
	{
		// your additional operations before save here
        $redirect_location = parent::updateCrud();
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
	}
	
	
	public function showDetailsRow($id) {
		return parent::showDetailsRow($id);
	}
}
