<?php

namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\TemplatesCategoriesRequest as StoreRequest;
use App\Http\Requests\TemplatesCategoriesRequest as UpdateRequest;

class TemplatesCategoriesCrudController extends CrudController
{

    public function setUp()
    {

        /*
		|--------------------------------------------------------------------------
		| BASIC CRUD INFORMATION
		|--------------------------------------------------------------------------
		*/
        $this->crud->setModel("App\Models\TemplateCategory");
        $this->crud->setRoute("admin/templatescategories");
        $this->crud->setEntityNameStrings('templates category', 'templates categories');
        $this->crud->enableDetailsRow();
        $this->crud->allowAccess('details_row');
        $this->crud->setDetailsRowView('templatescategories.details_row');

        /*
		|--------------------------------------------------------------------------
		| BASIC CRUD INFORMATION
		|--------------------------------------------------------------------------
		*/

        $this->crud->setFromDb();

        // ------ CRUD FIELDS
        // $this->crud->addField($options, 'update/create/both');
        // $this->crud->addFields($array_of_arrays, 'update/create/both');
        // $this->crud->removeField('name', 'update/create/both');
        // $this->crud->removeFields($array_of_names, 'update/create/both');
/*
        $this->crud->addField([
            'name' => 'subtitle',
            'label' => 'Subtitle',
            'type' => 'text',
        ]);
        $this->crud->addField([
            'name' => 'demo',
            'label' => 'Link to demo page',
            'type' => 'text',
        ]);
        $this->crud->addField([
            'name' => 'download',
            'label' => 'Link to downloadable archive',
            'type' => 'text',
        ]);
        $this->crud->addField([	// Image
            'name' => 'preview',
            'label' => 'Preview',
            'type' => 'image'
        ]);
        $this->crud->addField([	// Image
            'name' => 'preview_mobile',
            'label' => 'Preview Mobile',
            'type' => 'image'
        ]);
        $this->crud->addField([	// Image
            'name' => 'bg',
            'label' => 'Background for previews',
            'type' => 'image'
        ]);
        $this->crud->addField([	// Image
            'name' => 'img',
            'label' => 'Big Screenshot',
            'type' => 'image'
        ]);
        $this->crud->addField([	// Select2Multiple = n-n
            'label' => 'Tags',
            'type' => 'select2_multiple',
            'name' => 'tags',
            'entity' => 'tags',
            'attribute' => 'name',
            'model' => "App\Models\Tag",
            'pivot' => true,
        ]);
        $this->crud->addField([	// Select2Multiple = n-n
            'label' => 'Requirements',
            'type' => 'select2_multiple',
            'name' => 'requirements',
            'entity' => 'requirements',
            'attribute' => 'name',
            'model' => "App\Models\Requirement",
            'pivot' => true,
        ]);

        $this->crud->addField([
            'name' => 'price',
            'label' => 'Price',
            'type' => 'number',
            'prefix' => "$",
            'suffix' => ".00",
        ]);
        $this->crud->addField([
            'name' => 'price_installation',
            'label' => 'Instalation Template',
            'type' => 'number',
            'prefix' => "$",
            'suffix' => ".00",
        ]);
        $this->crud->addField([
            'name' => 'price_logo',
            'label' => 'Price Integration of your logo',
            'type' => 'number',
            'prefix' => "$",
            'suffix' => ".00",
        ]);
        $this->crud->addField([
            'name' => 'price_psd',
            'label' => 'Price PSD',
            'type' => 'number',
            'prefix' => "$",
            'suffix' => ".00",
        ]);
        $this->crud->addField([
            'name' => 'price_hosting',
            'label' => 'Price Install Hosting',
            'type' => 'number',
            'prefix' => "$",
            'suffix' => ".00",
        ]);
        $this->crud->addField([
                'name' => 'priority',
                'label' => 'Priority',
                'type' => 'number',
                'default' => 0
            ]
        );

        // ------ CRUD COLUMNS
        $this->crud->setColumnDetails('preview', [
            // run a function on the CRUD model and show its return value
            'label' => "Preview", // Table column heading
            'type' => "model_function",
            'function_name' => 'getPreview', // the method in your Model
        ]);

        $this->crud->setColumnDetails('demo', [
            'label' => 'Demo link',
            'type' => "model_function",
            'function_name' => 'getDemoLink', // the method in your Model
        ]);
        $this->crud->setColumnDetails('download', [
            'label' => 'Download link',
            'type' => "model_function",
            'function_name' => 'getDownloadLink', // the method in your Model
        ]);


        $this->crud->removeColumn('text');
        $this->crud->removeColumn('preview_mobile');
        $this->crud->removeColumn('bg');
        $this->crud->removeColumn('img');
        $this->crud->setColumnDetails('price_installation', ['label' => 'Installation']); // adjusts the properties of the passed in column (by name)
        $this->crud->setColumnDetails('price_logo', ['label' => 'Logo']); // adjusts the properties of the passed in column (by name)
        $this->crud->setColumnDetails('price_psd', ['label' => 'PSD']); // adjusts the properties of the passed in column (by name)
        $this->crud->setColumnDetails('price_hosting', ['label' => 'Hosting']); // adjusts the properties of the passed in column (by name)


        $this->crud->orderBy('sort', 'desc');
*/
        // $this->crud->groupBy();
        // $this->crud->limit();
    }

    public function store(StoreRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::storeCrud();
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
    }

    public function update(UpdateRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::updateCrud();
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
    }


    public function showDetailsRow($id) {
        return parent::showDetailsRow($id);
    }
}
