<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Template;
use App\Models\Order;
use App\Http\Requests\CartRequest;
use App\Http\Requests\OrderRequest;
use Gloudemans\Shoppingcart\Facades\Cart;
use PayPal\Api\Amount;
use PayPal\Api\CreditCard;
use PayPal\Api\Details;
use PayPal\Api\FundingInstrument;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\ExecutePayment;
use PayPal\Api\Payment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;

class CartController extends Controller {

	public function add(Request $request) {
		$template = Template::findOrFail($request->id);
		// Check if item is already in cart
		$in_cart = false;
		foreach (Cart::content() as $cartItem) {
			if ($cartItem->id == $template->id) {
				Cart::update($cartItem->rowId, ['options' => $request->options[$template->id]]);
				$in_cart = true;
				break;
			}
		}
		if (!$in_cart) {
			Cart::add($template, 1, $request->options[$template->id]);
		}
		return redirect()->route('cart');
	}

	public function remove($id) {
		Template::findOrFail($id);
		$in_cart = false;
		foreach (Cart::content() as $cartItem) {
			if ($cartItem->id == $id) {
				Cart::remove($cartItem->rowId);
				$in_cart = true;
				break;
			}
		}
		return ['result' => 'ok'];
	}

	public function show() {
		return $this->makeView();
	}
	
	private function getCartSum() {
		$cart_sum = 0;
		foreach (Cart::content() as $cartItem) {
			$cart_sum += $cartItem->model->price;
			if ($cartItem->options->has('installation')) {
				$cart_sum += $cartItem->model->price_installation;
			}
			if ($cartItem->options->has('logo')) {
				$cart_sum += $cartItem->model->price_logo;
			}
			if ($cartItem->options->has('psd')) {
				$cart_sum += $cartItem->model->price_psd;
			}
			if ($cartItem->options->has('hosting')) {
				$cart_sum += $cartItem->model->price_hosting;
			}
		}
		return $cart_sum;
	}

	public function checkout(Request $request) {
		// Updating selected options for templates
		if ($request && !empty($request->options)) {
			$ids = array_keys($request->options);
			foreach (Cart::content() as $cartItem) {
				if (in_array($cartItem->id, $ids)) {
					Cart::update($cartItem->rowId, ['options' => $request->options[$cartItem->id]]);
				}				
			}
		}
		$cart_sum = $this->getCartSum();
		return $this->makeView('pages.checkout', compact('cart_sum'));
	}
	
	private function getApiContext() {
		return new \PayPal\Rest\ApiContext(
				new \PayPal\Auth\OAuthTokenCredential(
					'AUuunzva8g9w3_qr6cXfxUVMDbrusj1NM8kxemn1aMm5piwreZKP7IBicBVXm4ZPg-bRVmnW8iDQACWz',
					'EODqhWK0E3KEnU-j77Lz4o3CW-1D93GbB3iM6vTMW41DNaFhfznvvuC8SoRWiMi7px1DQ6rbhxCCNnB6'
				)
		);
	}

	public function paymentCreditCard(OrderRequest $request) {
		$order = new \App\Models\Order;
		$id = $order->newOrder($request);
		
		$apiContext = $this->getApiContext();
		// Create credit card object and set funding instrument
		$card = new CreditCard();
		switch (substr($request->number, 0, 1)) {
			case '3': $type = 'amex'; break;
			case '4': $type = 'visa'; break;
			case '5': $type = 'mastercard'; break;
			case '6': $type = 'discover'; break;
			default: return redirect()->route('checkout_get');
		}
		$card->setType($type)
				->setNumber($request->number)
				->setExpireMonth($request->month)
				->setExpireYear($request->year)
				->setCvv2($request->cvv)
				->setFirstName($request->fname)
				->setLastName($request->lname);

		$fi = new FundingInstrument();
		$fi->setCreditCard($card);

		// Set payer to process credit card
		$payer = new Payer();
		$payer->setPaymentMethod("credit_card")
				->setFundingInstruments(array($fi));
		
		// Set total amount
		$amount = new Amount();
		$amount->setCurrency("USD")
				->setTotal($this->getCartSum());

		// Create transaction object with required data
		$transaction = new Transaction();
		$transaction->setAmount($amount)
				->setDescription("Web&Ad template");

		// Create payment object with required data
		$payment = new Payment();
		$payment->setIntent("sale")
				->setPayer($payer)
				->setTransactions(array($transaction));

		try {
			$payment->create($apiContext);
			echo $payment;
		} catch (PayPal\Exception\PayPalConnectionException $ex) {
			echo $ex->getCode();
			echo $ex->getData();
			var_dump($ex);
			exit;
//			die($ex);
		} catch (Exception $ex) {
			var_dump($ex);
			exit;
//			die($ex);
		}
		if ($payment->state == 'approved') {
			$order = Order::findOrFail($id);
			$order->is_paid = 1;
			$order->save();
			Cart::destroy();
			return $this->makeView('pages.thanks', ['order' => $order]);
		} else {
			return redirect()->route('order_cancel');
		}
	}

	public function paymentPayPal(OrderRequest $request) {
		
		$order = new \App\Models\Order;
		$request->sum = $this->getCartSum();
		$id = $order->newOrder($request);
		
		$apiContext = $this->getApiContext();
		// Create new payer and method
		$payer = new Payer();
		$payer->setPaymentMethod("paypal");

		// Set redirect urls
		$redirectUrls = new RedirectUrls();
		$redirectUrls->setReturnUrl(route('order_approve', ['id' => $id]))
					 ->setCancelUrl(route('order_cancel'));

		// Set payment amount
		$amount = new Amount();
		$amount->setCurrency("USD")
				->setTotal($this->getCartSum());

		// Set transaction object
		$transaction = new Transaction();
		$transaction->setAmount($amount)
				->setDescription("Web&Ad template");

		// Create the full payment object
		$payment = new Payment();
		$payment->setIntent('sale')
				->setPayer($payer)
				->setRedirectUrls($redirectUrls)
				->setTransactions(array($transaction));
		
		// Create payment with valid API context
		try {
			$payment->create($apiContext);

			// Get PayPal redirect URL and redirect user
			$approvalUrl = $payment->getApprovalLink();

			// REDIRECT USER TO $approvalUrl
		} catch (PayPal\Exception\PayPalConnectionException $ex) {
			echo $ex->getCode();
			echo $ex->getData();
			die($ex);
		} catch (Exception $ex) {
			die($ex);
		}
		return redirect($approvalUrl);
	}
	
	public function orderApprove($id) {
		$request = request();
		$apiContext = $this->getApiContext();
		// Get payment object by passing paymentId
		$paymentId = $request->paymentId;
		$payment = Payment::get($paymentId, $apiContext);
		$payerId = $request->PayerID;

		// Execute payment with payer id
		$execution = new PaymentExecution();
		$execution->setPayerId($payerId);

		try {
			// Execute payment
			$result = $payment->execute($execution, $apiContext);
			if ($result->state == 'approved') {
				$order = Order::findOrFail($id);
				$order->is_paid = 1;
				$order->save();
				
				Cart::destroy();
				return $this->makeView('pages.thanks', ['order' => $order]);
			} else {
				return $this->makeView('pages.payment_error', ['result' => $result]);
			}
		} catch (PayPal\Exception\PayPalConnectionException $ex) {
			echo $ex->getCode();
			echo $ex->getData();
			die($ex);
		} catch (Exception $ex) {
			die($ex);
		}
	}

	public function orderCancel() {
		return $this->makeView('pages.cancel');
	}

	public function paypalCreditCardError400() {
		return $this->makeView('paypal.400');
	}
	
	protected function makeView($tpl = 'pages.cart1', $vars = []) {
		return parent::makeView($tpl, $vars);
	}
}
