<?php

namespace App\Http\Controllers;

//
use App\Models\Service;
use App\Models\Template;
use App\Models\Article;
use App\Models\Category;
use App\Models\Tag;

use App\Models\TemplateCategory;
use Backpack\PageManager\app\Models\Page;
use Backpack\MenuCRUD\app\Models\Menuitem;

use App\Mail\ContactPageInquiry;
use App\Mail\ApplePayPageMail;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\SaveEmailRequest;
use App\Http\Requests\ContactPageRequest;
use App\Http\Requests\ApplePayPageRequest;


class MainController extends Controller
{

	/**
	 * Home Page
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function home()
	{
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		$services = Service::orderBy('priority', 'desc')->get();
		return view('pages.home')->with(compact('menu', 'services'));
	}

	/**
	 * Mail send from home page contact form
	 * 
	 * @param ContactRequest $request
	 * @return \Illuminate\Http\Response
	 */
	public function homeMail(ContactRequest $request)
	{
		$to = \Config::get('settings.contact_email');
		Mail::to($to)->send(new ContactFormMail($request));
		return view('pages.thanks');
	}

	/**
	 * Blog
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function blog()
	{
		$articles = Article::orderBy('date', 'desc')->with('category')->with('tags')->get();
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		return view('pages.blog')->with(compact('articles', 'menu'));
	}

	/**
	 * Blog Post
	 *
	 * @param  \App\Models\Article  $post
	 * @return \Illuminate\Http\Response
	 */
	public function blogPost(Article $post)
	{
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		return view('pages.blog_details')->with(compact('post', 'menu'));
	}

	/**
	 * Templates
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function templates()
	{
		$data = $this->getPageData('templates');
		//$data['page']=[];
		$templates_raw = Template::orderBy('priority', 'desc')->with('tags')->with('requirements')->with('category')->get();
		$categories = TemplateCategory::where('active', 1)->orderby('sort')->get();
		$data['categories'] = $categories;

		$templates = $templates_raw;
		/*
																			// Right order in two columns by priority
																			$templates = [];
																			$j = 0;
																			$half = ceil(count($templates_raw)/2);
																			for ($i = 0; $i < count($templates_raw); $i = $i+2) {
																				if (isset($templates_raw[$i])) {
																					$templates[$j] = $templates_raw[$i];
																				}
																				if (isset($templates_raw[$i+1])) {
																					$templates[$j+$half] = $templates_raw[$i+1];
																				}
																				$j++;
																			}
																			dd($templates);
																			ksort($templates);
																	*/
		return view('pages.templates')->with(array_merge($data, ['templates' => $templates]));
	}

	/**
	 * Blog Template
	 *
	 * @param  \App\Models\Template  $template
	 * @return \Illuminate\Http\Response
	 */
	public function templateDetails(Template $template)
	{
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		return view('pages.template_details')->with(compact('template', 'menu'));
	}

	/**
	 * Services
	 * 
	 * @return \Illuminate\Http\Response
	 */
	public function services()
	{
		$data = $this->getPageData('services');
		return view('pages.services', $data);
	}

	public function requestACall()
	{
		$data = $this->getPageData('request-a-call');
		return view('pages.call_request', $data);
	}

	protected function getPageData($slug)
	{
		//$page = Page::findBySlugOrFail($slug);
		$page = Page::findBySlug($slug);
		if (!$page) {
			abort(404, 'Please go back to our <a href="' . url('') . '">homepage</a>.');
		}
		$data = [];
		$data['_page_template'] = $page->template;
		$data['title'] = $page->title;
		$data['page'] = $page->withFakes();
		$data['menu'] = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		$data['services'] = Service::orderBy('priority', 'desc')->get();
		return $data;
	}

	public function page($slug)
	{
		$data = $this->getPageData($slug);
		return view('pages.' . $data['_page_template'], $data);
	}

	/**
	 * Save email process
	 * 
	 * @param SaveEmailRequest $request
	 * @return \Illuminate\Http\Response
	 */
	public function subscribe(SaveEmailRequest $request)
	{

		$mail = new \App\Models\Mail;
		$mail->mail = $request->mail;
		try {
			$res = $mail->save();
		} catch (\Illuminate\Database\QueryException $ex) {
			$res = false;
		}
		if ($res) {
			return $this->makeView('subscription.success');
		} else {
			return $this->makeView('subscription.error');
		}
	}

	/**
	 * Contact Page inquiries
	 * 
	 * @param ContactPageRequest $request
	 * @return \Illuminate\Http\Response
	 */
	public function inquiryCreate(ContactPageRequest $request)
	{
		$to = \Config::get('settings.contact_email');
		Mail::to($to)->send(new ContactPageInquiry($request));
		return $this->makeView('inquiry.success');
	}

	public function applePayLanding()
	{
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		$services = Service::orderBy('priority', 'desc')->get();
		return view('pages.apple_pay_landing')->with(compact('menu', 'services'));
	}

	/**
	 * Apple pay footer form
	 * 
	 * @param ApplePayPageRequest $request
	 * @return \Illuminate\Http\Response
	 */
	public function applePayForm(ApplePayPageRequest $request)
	{
		// $to = \Config::get('settings.contact_email');
		$to = 'petrenkorv95@gmail.com';
		Mail::to($to)->send(new ApplePayPageMail($request));
		return $this->makeView('inquiry.success');


		// $mail = new \App\Models\Mail;
		// $mail->mail = $request->mail;
		// try {
		// 	$res = $mail->save();
		// } catch (\Illuminate\Database\QueryException $ex) {
		// 	$res = false;
		// }
		// $res = 1;
		// return view('pages.thanks');
		// return $this->makeView('subscription.success');
		// if ($res) {
		// 	return $this->makeView('subscription.success');
		// } else {
		// 	return $this->makeView('subscription.error');
		// }
	}
}