<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use App\Http\Requests\OrderRequest;
use Gloudemans\Shoppingcart\Facades\Cart;

class Order extends Model
{
    use CrudTrait;

     /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

    protected $table = 'orders';
    protected $primaryKey = 'id';
     public $timestamps = true;
     protected $guarded = ['id'];
     protected $fillable = ['fname','lname','email','sum','is_paid'];
    // protected $hidden = [];
    // protected $dates = [];

    /*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/

	/**
     * Create a new order instance.
     *
     * @param  OrderRequest $request
     * @return integer
     */
    public function newOrder(OrderRequest $request)
    {
        $order = new Order;
        $order->fname = $request->fname;
        $order->lname = $request->lname;
        $order->email = $request->email;
        $order->sum = $request->sum;
        $res = $order->save();
		if ($res) {
			foreach (Cart::content() as $cartItem) {
				$order->templates()->attach($cartItem->id, [
					'installation' => $cartItem->options->has('installation'),
					'psd' => $cartItem->options->has('psd'),
					'logo' => $cartItem->options->has('logo'),
					'hosting' => $cartItem->options->has('hosting'),
				]);
			}
			return $order->id;
		} else {
			return false;
		}
	}
	
	
    /*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/
	public function templates() {
		return $this->belongsToMany("App\Models\Template", 'order_template');
	}
	public function order_templates() {
		return $this->hasMany("App\Models\OrderTemplate");
	}

	/*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

    /*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/

    /*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}
