function resize() {
  if ($(window).width() < 961) {
    $('#blogPosts').addClass('home-blog');
  }
  else {
    $('#blogPosts').removeClass('home-blog');
  }
}

$(document).ready(function($) { 
  $(window).resize(resize);
  resize();
  // Placeholder
  $('input').focus(function(){
    placeholder = $(this).attr('placeholder');
    if(placeholder != undefined){
      $(this).parent().prepend('<span class="input-placeholder">'+placeholder+'</span>');
      $(this).attr('placeholder', '');
    }
  });
  $('input').blur(function(){
    $(this).parent().find('.input-placeholder').remove();
  });
  // Radio
  $('.other-info.from .radio').on('click', function() {
    $('.other-info.from .radio').toggleClass('checks');
  });
  $('.other-info.to .radio').on('click', function() {
    $('.other-info.to .radio').toggleClass('checks');
  });  
  // Scroll To & Local Scroll  
  $('.scrollTo').bind('click', function(e) { 
    e.preventDefault();
    $('html, body').animate({
      scrollTop: $( $(this).attr('href')).offset().top
    }, 2000);
    return false;  
  });  
  // Rating
  var r_1 = $('.c-review .one');
  var r_2 = $('.c-review .two');
  var r_3 = $('.c-review .three');
  var r_4 = $('.c-review .four');
  var r_5 = $('.c-review .five');
  r_1.on('click', function() {
    r_1.addClass('checked');
    r_2.removeClass('checked');
    r_3.removeClass('checked');
    r_4.removeClass('checked');
    r_5.removeClass('checked');    
  });
  r_2.on('click', function() {
    r_1.addClass('checked');
    r_2.addClass('checked');
    r_3.removeClass('checked');
    r_4.removeClass('checked');
    r_5.removeClass('checked');    
  });
  r_3.on('click', function() {
    r_1.addClass('checked');
    r_2.addClass('checked');
    r_3.addClass('checked');
    r_4.removeClass('checked');
    r_5.removeClass('checked');    
  });
  r_4.on('click', function() {
    r_1.addClass('checked');
    r_2.addClass('checked');
    r_3.addClass('checked');
    r_4.addClass('checked');
    r_5.removeClass('checked');    
  });
  r_5.on('click', function() {
    r_1.addClass('checked');
    r_2.addClass('checked');
    r_3.addClass('checked');
    r_4.addClass('checked');
    r_5.addClass('checked');    
  });
  // Inputs
  $('.checkbox').on('click', function() {
    $(this).toggleClass('checks');
  });
  $('.r1 .radio').on('click', function() {
    $('.r1 .radio').toggleClass('checks');
    $('.ch-1').toggleClass('d-none');
  });
  $('.r2 .radio').on('click', function() {
    $('.r2 .radio').toggleClass('checks');
    $('.ch-2').toggleClass('d-none');
  });
  //  Mobile Menu
  $('.menu-btn').on('click', function(e) {
    e.preventDefault();    
    $('body').toggleClass('fix');
    $('.over').toggleClass('close');
    $('#menu').toggleClass('opens');
    $('#menu_home').toggleClass('opens');
  });

  // Fleets
  $('.c-slider').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 5000,
    arrows: false,
    dots: false,
    pauseOnHover: true,
    responsive: [{
      breakpoint: 960,
      settings: {
        slidesToShow: 1
      }
    }, {
      breakpoint: 520,
      settings: {
        slidesToShow: 1
      }
    }]
  });
  // Testimonials
  $('.testimonials').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 6000,
    arrows: false,
    dots: false,
    pauseOnHover: false,
    responsive: [{
      breakpoint: 960,
      settings: {
        slidesToShow: 1
      }
    }, {
      breakpoint: 520,
      settings: {
        slidesToShow: 1
      }
    }]
  });
  
  // Blog Home
  $('.home-blog').slick({
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 4000,
    arrows: false,
    dots: false,
    pauseOnHover: true,
    responsive: [{
      breakpoint: 960,
      settings: {
        slidesToShow: 2
      }
    }, {
      breakpoint: 520,
      settings: {
        slidesToShow: 1
      }
    }]
  });
});
// Blog Home
$('#blogPage').slick({
  slidesToShow: 3,
  slidesToScroll: 2,
  autoplay: true,
  autoplaySpeed: 4000,
  arrows: false,
  dots: true,
  pauseOnHover: true,
  responsive: [{
    breakpoint: 960,
    settings: {
      slidesToShow: 2
    }
  }, {
    breakpoint: 520,
    settings: {
      slidesToShow: 1
    }
  }]
});

// Fixed Navigation
$(document).scroll(function() {     
  var header_pos = $(window).scrollTop();
  if (header_pos >= 100) {
    $('.c-menu.home').addClass('move');
  }
  if (header_pos < 100) {
    $('.c-menu.home').removeClass('move');
  }
});