@extends('layout')
@section('title', isset($page->title)?$page->title:'Web&Ad')
@section('keywords', isset($page->meta_keywords)?$page->meta_keywords:'')
@section('description', isset($page->meta_description)?$page->meta_description:'')
@section('content')
<section id="about" class="about">
  <div class="about__top">
    <div class="container">
      <h2 class="about__title">{{ $page->title }}</h2>
    </div>
  </div>
  <div class="container">
    <div class="about__body">
      {!! $page->content !!}
    </div>
  </div>
</section>
<section id="form">
  <div class="container">
    <h2 class="service__title">Start your project</h2>
    <form id="start-project-form" class="contact-form" action="{{ route('create_inquiry') }}" method="post">
      {{ csrf_field() }}
      @if (count($errors) > 0)
        <div class="alert alert-danger">
          <ul>
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif
      <div class="col-sm-6">
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="name" class="contact-form__label">name:</label>
          <input id="name" name="name" value="{{ old('name') }}" type="text" class="form-control contact-form__input" required>
        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="company" class="contact-form__label">Company name:</label>
          <input id="company" name="company" value="{{ old('company') }}" type="text" class="form-control contact-form__input" required>
        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="phone" class="contact-form__label">phone number:</label>
          <input id="phone" name="phone" value="{{ old('phone') }}" type="text" class="form-control contact-form__input" required>
        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="email" class="contact-form__label">e-mail:</label>
          <input id="email" name="email" value="{{ old('email') }}" type="email" class="form-control contact-form__input" required>
        </div>
        <div class="form-group">
          <!--<h3 class="contact-form__title">What's are project needs?</h3>-->
          <ul class="contact-form__checkbox-group">
            <li class="contact-form__checkbox-item">
              <input id="branding" name="branding" type="checkbox" class="hidden">
              <label for="branding" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">Branding</span>
            </li>
            <li class="contact-form__checkbox-item">
              <input id="strategy" name="strategy" type="checkbox" class="hidden">
              <label for="strategy" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">Strategy</span>
            </li>
            <li class="contact-form__checkbox-item">
              <input id="video" name="video" type="checkbox" class="hidden">
              <label for="video" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">video</span>
            </li>
            <li class="contact-form__checkbox-item">
              <input id="animation" name="animation" type="checkbox" class="hidden">
              <label for="animation" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">Animation</span>
            </li>
            <li class="contact-form__checkbox-item">
              <input id="design" name="design" type="checkbox" class="hidden">
              <label for="design" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">web design</span>
            </li>
            <li class="contact-form__checkbox-item">
              <input id="development" name="development" type="checkbox" class="hidden">
              <label for="development" class="custom-checkbox"></label>
              <span class="contact-form__checkbox-text">web development</span>
            </li>
          </ul>

        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="notes" class="contact-form__label">Additional notes:</label>
          <textarea id="notes" name="notes" rows="5" class="form-control contact-form__input">{{ old('notes') }}</textarea>
        </div>
        <div class="form-group">
          <div class="captcha">
            <div class="g-recaptcha" data-sitekey="6Ld1mw0UAAAAADcjqKQPtbbHpmcRYR_EUzqYUDx_"></div>
          </div>
        </div>
        <div class="form-group">
          <button role="button" class="btn btn-green" type="submit">Send</button>
        </div>
      </div>
      <div class="col-sm-offset-2 col-sm-4">
        <div class="support-links">
          <a href="/request-a-call" class="support-link support-call">
            <i class="fa fa-phone"></i><br/>
            <span>Have us call you</span>
          </a>
          <a href="" class="support-link support-chat">
            <i class="fa fa-comments"></i><br/>
            <span>Chat with us</span>
          </a>
        </div>
      </div>
    </form>
  </div>
</section>
@endsection

@section('scripts')
@parent
@endsection


