@extends('layout')
@section('title', isset($title)?$title:'Web&Ad')
@section('content')
<section class=" index top-banner top-banner--full">
  <div class=" top-banner__body">
    <div class="container">
      <div class="row">
        <div class="main-banner-wrap">
          <div class="main-banner-wrap__left">
            <h1 class="main-banner__title wow fadeInLeft">FULL SERVICE SOLUTIONS FOR <span class="js-active-phrase"></span></h1>
            <p class="main-banner__sub-title wow fadeInUp">
              You need an all-round solution for website or application.<br>
              We are here to offer exactly that.
            </p>
          </div>
          <div class="main-banner-wrap__right wow fadeInRight">
            <div class="js-vticker-phrase-init">
              <ul class="dynamic-phrases">
                <li class="item">DIGITAL PRODUCTS</li>
                <li class="item">UI AND UX DESIGN</li>
                <li class="item">WEB DEVELOPMENT</li>
                <li class="item">APP DEVELOPMENT</li>
                <li class="item">ONLINE MARKETING</li>
                <li class="item">BRAND DESIGN</li>
                <li class="item">SUCCESS</li>
                <li class="item">RESULTS</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <a href="#services" class="scroll-down wow bounceIn" data-wow-delay="2.5s">
    <img src="/images/icons/angle-down.png">
  </a>
</section>
<section id="services" class="bg-white">
  <div class="container">
    <div class="row">
      <div class="service-index">
        @foreach($services as $s)
          <a href="/services#{{ $s->slug }}" class="service-index__item wow fadeIn{{ $s->fade }}">
            <div rv-class="s.wow" data-wow-delay="0.5s">
              <div class="service-index__img-wrap">
                <img class="service-index__img" src="/{{ $s->icon }}">
              </div>
              <img class="service-index__icon" src="/images/icons/plus_icon.png">
              <span class="service-index__title">{{ $s->name }}</span>
              <span class="service-index__description">{{ $s->short_text }}</span>
            </div>
          </a>
        @endforeach
      </div>
    </div>
  </div>
</section>
<section id="numbers" class="number-index__bg">
  <div class="container">
    <div class="numbers-description">
      <p>With us, you get a full service solution for your digital product. </p>
      <p>We can help improve your existing product or even build your startup from scratch. We are highly experienced in all-round IT projects.</p>
    </div>
    <div class="row">
      <div class="number-index">
        <div class="number-index__item">
          <span id="talents" class="number-index__val">{{ Config::get('settings.talents') }}</span>
          <span class="number-index__desc">TALENTED INDIVIDUALS</span>
        </div>
        <div class="number-index__item">
          <span id="clients" class="number-index__val">{{ Config::get('settings.clients') }}</span>
          <span class="number-index__desc">SATISFIED CLIENTS</span>
        </div>
        <div class="number-index__item">
          <span id="projects" class="number-index__val">{{ Config::get('settings.projects') }}</span>
          <span class="number-index__desc">COMPLETED PROJECTS</span>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection

@section('scripts')
@parent
<script>
  function counting(element, maxVal, speed, step) {
    var varCounter = 0;
    var varName = function () {
      if (varCounter < maxVal) {
        varCounter += step;
        element.text(varCounter);
      } else {
        clearInterval(varName);
      }
    };
    setInterval(varName, speed);
  }
     var waypoint = new Waypoint({
       element: $('.number-index'),
       handler: function () {
         counting($('#talents'), {{ Config::get('settings.talents') }}, 90, 1);
         counting($('#clients'), {{ Config::get('settings.clients') }}, 5, 1);
         counting($('#projects'), {{ Config::get('settings.projects') }}, 4, 1);
         this.destroy();
       },
       offset: 'bottom-in-view'
     });
</script>
@endsection


