@extends('layout')
@section('title', isset($page->meta_title)?$page->meta_title:$page->title)
@section('keywords', isset($page->meta_keywords)?$page->meta_keywords:'')
@section('description', isset($page->meta_description)?$page->meta_description:'')
@section('content')

<div class="clearfix"></div>
<section id="templates">
  <div class="template__wrap">
    <div class="template__column">
	@foreach($templates as $t)
     <div class="template__head"> 
        <span class="template-desc__title">{{ $t->name }}</span>
        <span class="template-desc__subtitle">{{ $t->subtitle }} </span>
      </div>
      <span class="template__item">
		@if(!empty($t->preview))<img class="template__img" src="{{ $t->preview }}">@endif
        <div class="template-desc ">
          <div class="template-desc__item">
            <div class="template-desc__ui">
              <img class="template-desc__img" src="/images/icons/screen_icon.png">
              <span class="template-desc__num">#{{ $t->id }}</span>
            </div>
      			<div class="template-desc__buttons">
      				@if(!empty($t->demo))
      				<button onclick="window.open('{{ $t->demo }}')">Live Demo</button>
      				@endif
      				<button onclick="window.location.href='{{ route('template', ['template' => $t->slug]) }}'">See Details</button>
      			</div>
            <div class="template-desc__price">${{ $t->price }}</div>
          </div>
          <div class="template-desc__item">
            <div class="avatar-share">
              <span class="icon-share">
                <span class="icons-share-wrap">
                  <a href="#" onclick="window.open('https://www.facebook.com/sharer/sharer.php?u='+'{{ route("template", ["template" => $t->slug]) }}&t={{ urlencode($t->name) }}','facebook-share-dialog','width=626,height=436');return false;" class="icon-facebook"></a>
                  <a href="#" onclick="window.open('http://twitter.com/share?text={{ urlencode($t->name) }}&url={{ route("template", ["template" => $t->slug]) }}','twitter-share-dialog','width=626,height=436');return false;" class="icon-twitter"></a>
                  <a href="#" onclick="window.open('https://vk.com/share.php?url={{ route("template", ["template" => $t->slug]) }}','vk-share-dialog','width=626,height=436');return false;" class="icon-vk"></a>
                  <a href="#" onclick="window.open('https://plus.google.com/share?url={{ route("template", ["template" => $t->slug]) }}','googleplus-share-dialog','width=626,height=436');return false;" class="icon-gplus"></a>
                  <a href="#" onclick="window.open('//pinterest.com/pin/create/button/?url={{ route("template", ["template" => $t->slug]) }}&description={{ urlencode($t->name) }}','pin-share-dialog','width=626,height=436');return false;" class="fa fa-pinterest"></a>
                  <a href="mailto:?subject={{ $t->name }}&body={{ route("template", ["template" => $t->slug]) }}" class="icon-mail"></a>
                </span>
              </span>
            </div>
			  <form action="{{ route('cart_add') }}" method="post">
				  {{ csrf_field() }}
				  <input type="hidden" name="id" value="{{ $t->id }}"/>
				  <button type="submit" class="btn btn-coral">
					  <span class="glyphicon glyphicon-shopping-cart" aria-hidden="true"></span>
					  Add to Cart</button>
			  </form>
          </div>
        </div>
	  </span>
	@if($loop->iteration == ceil($loop->count/2))
    </div><div class="template__column">
	@endif
	@endforeach
    </div>
  </div>
</section>

<section id="about" class="about">
  <div class="container">
    <div class="row">
      <div class="about__body">
        {!! $page->content !!}
      </div>
    </div>
  </div>
</section>
{{--
<div class="container">
  <div class="row">
    <div class="pagination__wrap">
      <ul class="pagination">
        <li class="pagination__item"><a class="pagination__link" href="#" aria-label="Previous"><span
          aria-hidden="true">Previous</span></a></li>
        <li class="active pagination__item"><a class="pagination__link" href="#">1</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#">2</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#">3</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#">4</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#">...</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#">10</a></li>
        <li class="pagination__item"><a class="pagination__link" href="#" aria-label="Next"><span
          aria-hidden="true">Next</span></a>
        </li>
      </ul>
    </div>
  </div>
</div>
--}}
@endsection
