@extends('layout')
@section('title', isset($template->name)?$template->name:'Web&Ad')
@section('content')
<section class="top-banner">
  <div class=" top-banner__body top-banner__body--bottom">
    <div class="container">
      <div class="row relative" style="" >
        <h1 class=" top-banner__title-left top-banner__title-left--temp" style="z-index: 999999;">{{ $template->name }}</h1>
        <p class=" top-banner__text top-banner__text--temp">{{ $template->subtitle }}</p>
      </div>
    </div>
  </div>
  <div class="breadcrumb-wrap">
    <div class="my-breadcrumb">
      <li class="my-breadcrumb__item"><a href="/">home</a></li>
      <li class="my-breadcrumb__item"><a href="{{ route('templates') }}">templates</a></li>
      <li class="my-breadcrumb__item active">{{ $template->name }}</li>
    </div>
  </div>
</section>
<section id="">
{{--
  <div class="template__top">
    <div class="container">
      <div class="template-desc__stars">
        <i class="red-star star star--sm wow fadeIn" data-wow-delay="2.2s"></i>
        <i class="red-star star star--sm wow fadeIn" data-wow-delay="2.4s"></i>
        <i class="red-star star star--sm wow fadeIn" data-wow-delay="2.6s"></i>
        <i class="red-star star star--sm wow fadeIn" data-wow-delay="2.8s"></i>
        <i class="empty-star star star--sm wow fadeIn" data-wow-delay="3s"></i>
      </div>
      <ul class="template-desc__details">
        <li class="template-desc__details-item"><span>Type:</span><span>Word Press</span></li>
        <li class="template-desc__details-item"><span>#</span><span>$template->id</span></li>
        <li class="template-desc__details-item"><span>Author:</span><span>Web&amp;Ad</span></li>
        <li class="template-desc__details-item"><span>Downloads:</span><span>301</span></li>
      </ul>
	  
      <ul class="template-desc__social">
		  <li><a href="#" onclick="window.open('https://www.facebook.com/sharer/sharer.php?u='+'{{ route("template", ["template" => $template->slug]) }}&t={{ urlencode($template->name) }}','facebook-share-dialog','width=626,height=436');return false;" class="template-desc__slink template-desc__slink--facebook"><i class="fa fa-facebook-f"></i></a></li>
        <li><a href="#" onclick="window.open('http://twitter.com/share?text={{ urlencode($template->name) }}&url={{ route("template", ["template" => $template->slug]) }}','twitter-share-dialog','width=626,height=436');return false;" class="template-desc__slink template-desc__slink--twitter"><i class="fa fa-twitter"></i></a></li>
        <li><a href="#" onclick="window.open('https://vk.com/share.php?url={{ route("template", ["template" => $template->slug]) }}','vk-share-dialog','width=626,height=436');return false;" class="template-desc__slink template-desc__slink--vk"><i class="fa fa-vk"></i></a></li>
        <li><a href="#" onclick="window.open('https://plus.google.com/share?url={{ route("template", ["template" => $template->slug]) }}','googleplus-share-dialog','width=626,height=436');return false;" class="template-desc__slink template-desc__slink--gplus"><i class="fa fa-google-plus"></i></a></li>
        <li><a href="#" onclick="window.open('//pinterest.com/pin/create/button/?url={{ route("template", ["template" => $template->slug]) }}&description={{ urlencode($template->name) }}','pin-share-dialog','width=626,height=436');return false;" class="template-desc__slink template-desc__slink--pinterest"><i class="fa fa-pinterest"></i></a></li>
        <li><a href="mailto:?subject={{ $template->name }}&body={{ route("template", ["template" => $template->slug]) }}" class="template-desc__slink template-desc__slink--mail"><i class="fa fa-mail-forward"></i></a></li>
      </ul>
    </div>
  </div>
--}}

  <div class="template__wrap">
    <div class="template-wide">
      <div class="template-detail-preview">
		@if(!empty($template->preview_mobile))<img class="template-detail-preview__mobile wow fadeInLeftBig" src="/{{ $template->preview_mobile }}">@endif
		@if(!empty($template->preview))<img class="template-detail-preview__screen wow fadeInRightBig" src="/{{ $template->preview }}" >@endif

      </div>
      <div class="">
        <p class="template-price__bottom-text">{{ $template->subtitle }}</p>
        <h3>{{ $template->subtitle }}</h3>
      </div>
      <p class="template-desc__text">{{ $template->text }}</p>
    </div>
    <div class="template-narrow template-narrow--right">
      <div class="template-price">
		<form class="template-price__form" action="{{ route('cart_add') }}" method="post">
			{{ csrf_field() }}
			<input type="hidden" name="id" value="{{ $template->id }}"/>
			<input type="checkbox" name="options[{{$template->id}}][template]" value="{{$template->price}}" disabled="" checked=""/>
          <table class="table table-responsive">
            <tbody>
	  @if(!empty($template->price))
            <tr>
              <td colspan="2" class="template-price__total">The license for one-time use</td>
              <td class="template-price__total">${{ $template->price }}.00</td>
            </tr>
	  @endif
	  
	  @if(!empty($template->price_installation))
            <tr>
              <td><input id="installation" name="options[{{$template->id}}][installation]" value="{{$template->price_installation}}" type="checkbox">
                <label class="template-price__label" for="installation"></label>
              </td>
              <td class="template-price__text"><label for="installation">Instalation Template</label></td>
              <td class="template-price__val">${{ $template->price_installation }}.00</td>
            </tr>
	  @endif
	  
	  @if(!empty($template->price_logo))
            <tr>
              <td><input id="instlogo" name="options[{{$template->id}}][logo]" value="{{$template->price_logo}}" type="checkbox">
                <label class="template-price__label" for="instlogo"></label>
              </td>
              <td class="template-price__text"><label for="instlogo">Integration of your logo</label></td>
              <td class="template-price__val">${{ $template->price_logo }}.00</td>
            </tr>
	  @endif
	  
	  @if(!empty($template->price_psd))
            <tr>
              <td><input id="psd" name="options[{{$template->id}}][psd]" value="{{$template->price_psd}}" type="checkbox">
                <label class="template-price__label" for="psd"></label>
              </td>
              <td class="template-price__text"><label for="psd">PSD</label></td>
              <td class="template-price__val">${{ $template->price_psd }}.00</td>
            </tr>
	  @endif
	  
	  @if(!empty($template->price_hosting))
            <tr>
              <td><input id="hosting" name="options[{{$template->id}}][hosting]" value="{{$template->price_hosting}}" type="checkbox">
                <label class="template-price__label" for="hosting"></label>
              </td>
              <td class="template-price__text"><label for="hosting">Install Hosting</label></td>
              <td class="template-price__val">${{ $template->price_hosting }}.00</td>
            </tr>
	  @endif
            <tr>
              <td></td>
              <td class="template-price__total">Total</td>
              <td class="template-price__total" id="price_total">${{ $template->price }}.00</td>
            </tr>
            </tbody>
          </table>
          <div class="">
            <button class="btn btn-red template-price__submit" type="submit">Add Cart</button>
          </div>
          <div class="template-price__credit-cards">
            <img src="/images/icons/mastercard.png">
            <img src="/images/icons/amex.png">
            <img src="/images/icons/visa.png">
            <img src="/images/icons/discover.png">
            <img src="/images/icons/paypal_2.png">
          </div>
        </form>
      </div>
    </div>
  </div>
  <div class="template__wrap">
    <div class="template-narrow">
      <h2 class="template-desc__title text-uppercase">{{ $template->name }}</h2>
    </div>

    <div class="template-wide">
    </div>
  </div>
  <div class="template__wrap">
    @if(count($template->requirements)!=0 || count($template->tags)!=0)
    <div class="template-narrow template-narrow--left">
      <p class="template-desc__text">{{ $template->text }}</p>
	  @if(!empty($template->requirements))
      <ul class="template-desc__stack">
		 <li>{!! $template->requirements->implode('name', '</li><li>') !!}</li>
      </ul>
	  @endif
	  @if(!empty($template->tags))
      <ul class="template-desc__tags">
		 <li>{!! $template->tags->implode('name', '</li><li>') !!}</li>
      </ul>
	  @endif
    </div>
    @endif

      @if(!empty($template->img))
      <div class="template-wide">
        <div class=""><img class="img-responsive" src="/{{ $template->img }}">
        </div>
      </div>
      @endif
  </div>

</section>
@endsection

@section('scripts')
@parent
<script>

function updateTotalPrice() {
	var sum = 0;
    $('.template-price input:checkbox:checked').each(function() {
        sum += Number($(this).val());
    });
	$('#price_total').html('$' + sum + '.00');
}
$('.template-price input:checkbox').change(function () {
	updateTotalPrice();
});
updateTotalPrice();

</script>
@endsection