<?php

namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;
// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\TagRequest as StoreRequest;
use App\Http\Requests\TagRequest as UpdateRequest;

class TagCrudController extends CrudController {

	public function __construct() {
		parent::__construct();

		/*
		  |--------------------------------------------------------------------------
		  | BASIC CRUD INFORMATION
		  |--------------------------------------------------------------------------
		 */
		$this->crud->setModel("App\Models\Tag");
		$this->crud->setRoute("admin/tag");
		$this->crud->setEntityNameStrings('tag', 'tags');

		/*
		  |--------------------------------------------------------------------------
		  | COLUMNS AND FIELDS
		  |--------------------------------------------------------------------------
		 */

		$this->crud->setFromDb();
	}

	public function store(StoreRequest $request) {
		return parent::storeCrud();
	}

	public function update(UpdateRequest $request) {
		return parent::updateCrud();
	}

}
