<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	
	protected function makeView($tpl, $vars = []) {
		$menu = \Backpack\MenuCRUD\app\Models\MenuItem::getTree();
		return view($tpl)->with(array_merge(compact('menu'), $vars));
	}
}
