<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;

class Article extends Model {

	use CrudTrait;

use Sluggable;

	/*
	  |--------------------------------------------------------------------------
	  | GLOBAL VARIABLES
	  |--------------------------------------------------------------------------
	 */

	protected $table = 'articles';
	protected $primaryKey = 'id';
	public $timestamps = true;
	// protected $guarded = ['id'];
	protected $fillable = ['slug', 'title', 'content', 'image', 'status', 'category_id', 'featured', 'date'];
	// protected $hidden = [];
	// protected $dates = [];
	protected $casts = [
		'featured' => 'boolean',
		'date' => 'date',
	];

	/**
	 * Return the sluggable configuration array for this model.
	 *
	 * @return array
	 */
	public function sluggable() {
		return [
			'slug' => [
				'source' => 'slug_or_title',
			],
		];
	}

	public function getRouteKeyName() {
		return 'slug';
	}

	/*
	  |--------------------------------------------------------------------------
	  | FUNCTIONS
	  |--------------------------------------------------------------------------
	 */

	public function getFeaturedColumn() {
		return $this->featured ? '<i class="fa fa-check"></i>' : '<i class="fa fa-times"></i>';
	}

	/*
	  |--------------------------------------------------------------------------
	  | RELATIONS
	  |--------------------------------------------------------------------------
	 */

	public function category() {
		return $this->belongsTo("App\Models\Category", 'category_id');
	}

	public function tags() {
		return $this->belongsToMany("App\Models\Tag", 'article_tag');
	}

	/*
	  |--------------------------------------------------------------------------
	  | SCOPES
	  |--------------------------------------------------------------------------
	 */

	public function scopePublished($query) {
		return $query->where('status', 'PUBLISHED')
						->where('date', '<=', date('Y-m-d'))
						->orderBy('date', 'DESC');
	}

	/*
	  |--------------------------------------------------------------------------
	  | ACCESORS
	  |--------------------------------------------------------------------------
	 */

	// The slug is created automatically from the "title" field if no slug exists.
	public function getSlugOrTitleAttribute() {
		if ($this->slug != '') {
			return $this->slug;
		}

		return $this->title;
	}

	public function getIntroAttribute() {
		$dot = strpos($this->content, '.');
		if ($dot === false || $dot === 0) {
			$dot = strlen($this->content);
		}
		return strip_tags(substr($this->content, 0, $dot));
	}
	
	/*
	  |--------------------------------------------------------------------------
	  | MUTATORS
	  |--------------------------------------------------------------------------
	 */
}
