<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;

class Service extends Model
{
    use CrudTrait;
	use Sluggable;

     /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

    protected $table = 'services';
    protected $primaryKey = 'id';
     public $timestamps = true;
    // protected $guarded = ['id'];
     protected $fillable = ['name', 'slug', 'icon', 'icon_big', 'icon_red', 'fade', 'text', 'priority', 'short_text'];
//     protected $hidden = [];
    // protected $dates = [];

    /*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/
	public function sluggable() {
		return [
			'slug' => [
				'source' => 'slug_or_name',
			],
		];
	}

	public function getRouteKeyName() {
		return 'slug';
	}
	public function getIconBig() {
		return '<img src="/' . $this->icon_big . '" width="150" alt="">';
	}
	public function getIcon() {
		return '<img src="/' . $this->icon . '" width="" alt="">';
	}

    /*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/

    /*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

    /*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/
    // The slug is created automatically from the "name" field if no slug exists.
    public function getSlugOrNameAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return $this->name;
    }

    /*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
	public function setPriorityAttribute($value) {
		$this->attributes['priority'] = is_null($value) ? 0 : (int) $value;
	}
}
