<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Cviebrock\EloquentSluggable\Sluggable;
use \Gloudemans\Shoppingcart\Contracts\Buyable;

class Template extends Model implements Buyable
{
    use CrudTrait;
    use Sluggable;

     /*
	|--------------------------------------------------------------------------
	| GLOBAL VARIABLES
	|--------------------------------------------------------------------------
	*/

    protected $table = 'templates';
    protected $primaryKey = 'id';
     public $timestamps = true;
//     protected $guarded = ['id'];
     protected $fillable = ['name', 'subtitle', 'preview', 'preview_mobile', 'bg', 'img', 'text', 'price', 'price_installation', 'price_logo', 'price_psd', 'price_hosting', 'demo', 'download', 'priority','category_id'];
    // protected $hidden = [];
    // protected $dates = [];

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'slug_or_name',
            ],
        ];
    }

	public function getRouteKeyName() {
		return 'slug';
	}
	
	/*
	|--------------------------------------------------------------------------
	| Buyable interface
	|--------------------------------------------------------------------------
	 */
	public function getBuyableIdentifier($options = null){
        return $this->id;
    }

    public function getBuyableDescription($options = null){
        return $this->name;
    }

    public function getBuyablePrice($options = null){
        return $this->price;
    }

    /*
	|--------------------------------------------------------------------------
	| FUNCTIONS
	|--------------------------------------------------------------------------
	*/
	public function getDemoLink() {
		if (!empty($this->demo)) {
			return '<a href="' . $this->demo. '" target="_blank"><span class="fa fa-external-link"></span></a>';
		} else {
			return '&mdash;';
		}
	}
	public function getDownloadLink() {
		if (!empty($this->download)) {
			return '<a href="' . $this->download. '" target="_blank"><span class="fa fa-external-link"></span></a>';
		} else {
			return '&mdash;';
		}
	}
	public function getPreview() {
		return '<img src="/' . $this->preview . '" width="150" alt="">';
	}
	public function getPreviewMobile() {
		return '<img src="/' . $this->preview_mobile . '" width="150" alt="">';
	}
	public function getBg() {
		return '<img src="/' . $this->bg . '" width="150" alt="">';
	}
	public function getImg() {
		return '<img src="/' . $this->img . '" width="150" alt="">';
	}


    /*
	|--------------------------------------------------------------------------
	| RELATIONS
	|--------------------------------------------------------------------------
	*/
	public function tags() {
		return $this->belongsToMany("App\Models\Tag", 'template_tag');
	}
	public function requirements() {
		return $this->belongsToMany("App\Models\Requirement", 'template_requirement');
	}
	public function orders() {
		return $this->belongsToMany("App\Models\Order", 'order_template');
	}

    /*
	|--------------------------------------------------------------------------
	| SCOPES
	|--------------------------------------------------------------------------
	*/

    /*
	|--------------------------------------------------------------------------
	| ACCESORS
	|--------------------------------------------------------------------------
	*/
    // The slug is created automatically from the "name" field if no slug exists.
    public function getSlugOrNameAttribute()
    {
        if ($this->slug != '') {
            return $this->slug;
        }

        return $this->name;
    }

    public function category()
    {
        return $this->belongsTo('App\Models\TemplateCategory','category_id');
    }

    /*
	|--------------------------------------------------------------------------
	| MUTATORS
	|--------------------------------------------------------------------------
	*/
}
