<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('templates', function (Blueprint $table) {
            $table->string('slug')->unique()->after('name');
            $table->string('subtitle')->after('name')->nullable();
            $table->integer('price')->unsigned()->nullable();
            $table->integer('price_installation')->unsigned()->nullable();
            $table->integer('price_logo')->unsigned()->nullable();
            $table->integer('price_psd')->unsigned()->nullable();
            $table->integer('price_hosting')->unsigned()->nullable();
            $table->string('demo')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('templates', function (Blueprint $table) {
            $table->dropColumn('slug');
            $table->dropColumn('subtitle');
            $table->dropColumn('price');
            $table->dropColumn('price_installation');
            $table->dropColumn('price_logo');
            $table->dropColumn('price_psd');
            $table->dropColumn('price_hosting');
            $table->dropColumn('demo');
        });
    }
}
