$(function () {
	  if($('.preloadDomReady .inner').length) {
		  $('body').css({
		  	'padding-right': $(window).width() - $('.preloadDomReady .inner').width()
		  });
	  }

  	$('.preloadDomReady').fadeOut(300);
  	$('.preloadDomReady').promise().done(function() {
  		$('body').addClass('dom-ready');
      if( $('.js-vticker-phrase-init').length > 0 ) {
        appPhrases.init();
      }
  	});
});

// Phrases effect
(function() {
    var appPhrases = {

      initPhrazePlugin: function() {
        if($('.main-banner-wrap').length > 0) {
          $('.main-banner-wrap').css('visibility', 'visible')
                                .promise()
                                .done(
            function(){
              $('.js-vticker-phrase-init').vTicker({
                showItems: 8,
                pause: 3500, 
                padding: 6,
                mousePause: false
              });
            });
        }
      },
      
      tickBeforeResult: function() {
        var activePhIndex = ($('.js-vticker-phrase-init .item').length/2).toFixed(0);
        var activeItem =  $('.js-vticker-phrase-init .item').eq(activePhIndex);
        activeItem.addClass('is-active');
        $('.js-active-phrase').text( activeItem.text() );
        $('.js-vticker-phrase-init').on('vticker.beforeTick', function() {
          var activePhIndex = ($('.js-vticker-phrase-init .item').length/2).toFixed(0);
          var activeItem =  $('.js-vticker-phrase-init .item').eq(activePhIndex);
          $('.js-vticker-phrase-init .item').removeClass('is-active');
          activeItem.next().addClass('is-active');
          $('.js-active-phrase').addClass('is-change');
          setTimeout(function() {
            $('.js-active-phrase').removeClass('is-wait')
          },1100);
        });
      },

      tickAfterResult: function() { 
        $('.js-vticker-phrase-init').on('vticker.afterTick', function() {
          var activePhIndex = ($('.js-vticker-phrase-init .item').length/2).toFixed(0);
          var activeItem =  $('.js-vticker-phrase-init .item').eq(activePhIndex);
          $('.js-active-phrase').text( activeItem.text() );
          $('.js-active-phrase').removeClass('is-change').addClass('is-wait');
        });
      },

      init: function() {
        this.initPhrazePlugin();
        this.tickBeforeResult();
        this.tickAfterResult();
      }
    }
  window.appPhrases = appPhrases;

  return window.appPhrases;

})();


