@foreach(Cart::content() as $row) 
<div class="order" data-id="{{ $row->id }}">
	@if(!empty($row->model->preview))
	<div class="order__img-wrap">
		<img class="order__img" src="/{{ $row->model->preview }}">
		<div class="remove_order_item"><a href="{{ route('cart_remove', ['id' => $row->rowId]) }}"><span></span>Remove</a></div>
	</div>
	@endif
	<div class="order__body">
		<style>
			input#price_{{ $row->id }}_template[type=checkbox]:checked+.order__add-top:after {content: "${{ $row->model->price}}.00";}
			input#price_{{ $row->id }}_installation[type=checkbox]:checked+.order__add:after {content: "${{ $row->model->price_installation}}.00";}
			input#price_{{ $row->id }}_logo[type=checkbox]:checked+.order__add:after {content: "${{ $row->model->price_logo}}.00";}
			input#price_{{ $row->id }}_psd[type=checkbox]:checked+.order__add:after {content: "${{ $row->model->price_psd}}.00";}
			input#price_{{ $row->id }}_hosting[type=checkbox]:checked+.order__add:after {content: "${{ $row->model->price_hosting}}.00";}
		</style>
		<table class="table table-responsive">
            <tbody>
				<tr>
					<td>
						<span class="order__name">{{ $row->model->name }}</span>
					</td>
					<td>
						<input class="base_price" id="price_{{ $row->id }}_template" name="options[{{$row->id}}][template]" value="{{ $row->model->price }}" type="hidden">
						<span class="order_row_total">${{ $row->model->price }}.00</span>
					</td>
				</tr>
				@if($row->model->price_installation > 0)
				<tr>
					<td><span class="order__text">Instalation Template</span></td>
					<td>
						<input id="price_{{ $row->id }}_installation" name="options[{{$row->id}}][installation]" value="{{ $row->model->price_installation }}" type="checkbox"{{ $row->options->has('installation')?'checked':'' }}>
						<label class="order__add" for="price_{{ $row->id }}_installation"><span>+ ${{ $row->model->price_installation }}.00</span></label>
					</td>
				</tr>
				@endif
				@if($row->model->price_logo > 0)
				<tr>
					<td><span class="order__text">Integration of your logo</span></td>
					<td>
						<input id="price_{{ $row->id }}_logo" name="options[{{$row->id}}][logo]" value="{{ $row->model->price_logo }}" type="checkbox"{{ $row->options->has('logo')?'checked':'' }}>
						<label class="order__add" for="price_{{ $row->id }}_logo"><span>+ ${{ $row->model->price_logo }}.00</span></label>
					</td>
				</tr>
				@endif
				@if($row->model->price_psd > 0)
				<tr>
					<td><span class="order__text">PSD</span></td>
					<td>
						<input id="price_{{ $row->id }}_psd" name="options[{{$row->id}}][psd]" value="{{ $row->model->price_psd}}" type="checkbox"{{ $row->options->has('psd')?'checked':'' }}>
						<label class="order__add" for="price_{{ $row->id }}_psd"><span>+ ${{ $row->model->price_psd }}.00</span></label>
					</td>
				</tr>
				@endif
				@if($row->model->price_hosting > 0)
				<tr>
					<td><span class="order__text">Install Hosting</span></td>
					<td>
						<input id="price_{{ $row->id }}_hosting" name="options[{{$row->id}}][hosting]" value="{{ $row->model->price_hosting}}" type="checkbox"{{ $row->options->has('hosting')?'checked':'' }}>
						<label class="order__add" for="price_{{ $row->id }}_hosting"><span>+ ${{ $row->model->price_hosting }}.00</span></label>
					</td>
				</tr>
				@endif
				<tr>
					<td><span class="order__total">Total:</span></td>
					<td><span class="order__total order__total--lg" id="price_{{ $row->id }}_total">$0.00</span></td>
				</tr>
            </tbody>
		</table>
	</div>
</div>
@endforeach
{{--
<div class="order">
	<div class="order__img-wrap">&nbsp;</div>
	<div class="order__body">
		<table class="table table-responsive">
			<tbody>
				<tr>
					<td><span class="order__total">Total:</span></td>
					<td><span class="order__total order__total--lg" id="price_total">$0.00</span></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
--}}
@section('scripts')
@parent
<script>
function updateTemplatePrice(id) {
	var sum = 0;
	var base_price = Number($('.order[data-id="'+ id +'"] .base_price').val());
    $('.order[data-id="'+ id +'"] input:checkbox:checked').each(function() {
        sum += Number($(this).val());
    });
    sum += base_price;
	$('#price_' + id + '_total').html('$' + sum + '.00');
}
function updateTotalPrice() {
	var sum = 0;
    $('.order__body input:checkbox:checked').each(function() {
        sum += Number($(this).val());
    });
	$('#price_total').html('$' + sum + '.00');
}
$('.order__body input:checkbox').change(function () {
	var id = $(this).parents('.order').data('id');
	console.log($(this).attr('name'));
	console.log('price['+id+'][template]');
	updateTemplatePrice(id);
//	updateTotalPrice();
});
$('.remove_order_item a').click(function(e){
    e.preventDefault();
    var id = $(this).parents('.order').data('id');
    $.get("/cart/remove/"+id, function() {
        $('.order[data-id="'+id+'"]').remove();
    });
    updateTemplatePrice(id);
});
@foreach(Cart::content() as $row)
updateTemplatePrice({{ $row->id }});
@endforeach
//updateTotalPrice();
</script>
@endsection