@extends('layout')
@section('title', isset($page->title)?$page->title:'Web&Ad')
@section('keywords', isset($page->meta_keywords)?$page->meta_keywords:'')
@section('description', isset($page->meta_description)?$page->meta_description:'')
@section('content')
<section id="about" class="about">
  <div class="about__top">
    <div class="container">
      <h2 class="about__title">{{ $page->title }}</h2>
    </div>
  </div>
  <div class="container">
    <div class="about__body">
      {!! $page->content !!}
    </div>
  </div>
</section>
<section id="form">
  <div class="container">
    <form id="start-project-form" class="contact-form" action="{{ route('create_inquiry') }}" method="post">
      {{ csrf_field() }}
      @if (count($errors) > 0)
        <div class="alert alert-danger">
          <ul>
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif
      <div class="col-sm-6">
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="name" class="contact-form__label">name:</label>
          <input id="name" name="name" value="{{ old('name') }}" type="text" class="form-control contact-form__input" required>
        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="phone" class="contact-form__label">phone number:</label>
          <input id="phone" name="phone" value="{{ old('phone') }}" type="text" class="form-control contact-form__input" required>
        </div>
        <h3 class="contact-form__title"></h3>
        <div class="form-group">
          <label for="notes" class="contact-form__label">How can we help?</label>
          <textarea id="notes" name="notes" rows="5" class="form-control contact-form__input">{{ old('notes') }}</textarea>
        </div>
        <div class="form-group">
          <div class="captcha">
            <div class="g-recaptcha" data-sitekey="6Ld1mw0UAAAAADcjqKQPtbbHpmcRYR_EUzqYUDx_"></div>
          </div>
        </div>
        <div class="form-group">
          <button role="button" class="btn btn-green" type="submit">Send</button>
        </div>
      </div>
      
    </form>
  </div>
</section>
@endsection

@section('scripts')
@parent
@endsection


