@extends('layout')
@section('title', isset($page->meta_title)?$page->meta_title:$page->title)
@section('keywords', isset($page->meta_keywords)?$page->meta_keywords:'')
@section('description', isset($page->meta_description)?$page->meta_description:'')
@section('content')
<section id="about" class="about">
  <div class="about__top">
    <div class="container">
      <h2 class="about__title">{{ $page->title }}</h2>
    </div>
  </div>
  <div class="container">
      <div class="about__body">
        {!! $page->content !!}
    </div>
  </div>
</section>
<section id="service-about" class="service-about">
  <h2 class="service-about__title">Our services</h2>
  <div id="service-slider" class="service-about__group">
    @foreach($services as $s)
      <a class="service-about__item" href="/services#{{ $s->slug }}">
        <div class="service-about__img-wrap">
          <img class="service-about__img" src="/{{ $s->icon }}">
        </div>
        <div class="service-about__desc">{{ $s->name }}</div>
      </a>
    @endforeach
  </div>
</section>
@endsection

@section('scripts')
@parent
<script>rivets.bind($('#service-about'), {service_about: services})</script>
@endsection


