<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group([
    'prefix' => config('backpack.base.route_prefix', 'admin'),
    'middleware' => ['admin'],
    'namespace' => 'Admin'
], function () {
    // your CRUD resources and other admin routes here
//    CRUD::resource('fleet', 'FleetCrudController');
//    CRUD::resource('vehicle', 'VehicleCrudController');
    CRUD::resource('article', 'ArticleCrudController');
    CRUD::resource('category', 'CategoryCrudController');
    CRUD::resource('tag', 'TagCrudController');
    CRUD::resource('requirement', 'RequirementCrudController');
    CRUD::resource('template', 'TemplateCrudController');
    CRUD::resource('service', 'ServiceCrudController');
    CRUD::resource('order', 'OrderCrudController');
    CRUD::resource('mail', 'MailCrudController');
});

Route::get('/cart', 'CartController@show')->name('cart');
Route::post('/cart/add', 'CartController@add')->name('cart_add');
Route::get('/cart/remove/{id}', 'CartController@remove')->name('cart_remove');
Route::get('/cart/checkout', 'CartController@checkout')->name('checkout_get');
Route::post('/cart/checkout', 'CartController@checkout')->name('checkout');
Route::post('/cart/payment_cc', 'CartController@paymentCreditCard')->name('payment_cc');
Route::post('/cart/payment_pp', 'CartController@paymentPayPal')->name('payment_pp');
Route::get('/cart/approve/{id}', 'CartController@orderApprove')->name('order_approve');
Route::get('/cart/error', 'CartController@orderCancel')->name('order_cancel');
Route::get('/cart/error/400', 'CartController@paypalCreditCardError400')->name('paypal_error_400');
Route::get('/cart/thanks', 'CartController@thanks')->name('thanks');

Route::get('/', 'MainController@home')->name('home');
Route::post('/', 'MainController@homeMail')->name('home_mail');
Route::get('/blog', 'MainController@blog')->name('blog');
Route::get('/blog/{post}', 'MainController@blogPost')->name('blog_post');
Route::get('/services', 'MainController@services')->name('services');
Route::get('/request-a-call', 'MainController@requestACall')->name('request_a_call');
Route::get('/templates', 'MainController@templates')->name('templates');
Route::get('/templates/{template}', 'MainController@templateDetails')->name('template');
Route::post('/contact', 'MainController@inquiryCreate')->name('create_inquiry');
Route::post('/request-a-call', 'MainController@requestCallCreate')->name('create_call_request');
Route::get('/apple_pay_and_authorize_net_applepay', 'MainController@applePayLanding')->name('apple_pay_landing');
Route::get('{page}/{subs?}', ['uses' => 'MainController@page'])
    ->where(['page' => '^((?!admin).)*$', 'subs' => '.*'])->name('page');


Route::post('/subscribe', 'MainController@subscribe')->name('subscribe');
Route::post('/applePayForm', 'MainController@applePayForm')->name('apple_pay_form');