<ul id="" class="nav nav-tabs contact-tabs" role="tablist">
	<li role="presentation" class="active contact-tabs__item">
		<a class="contact-tabs__link" href="#cc" aria-controls="start" role="tab" data-toggle="tab">
			<div class="credit-cards">
				<img src="/images/icons/mastercard.png">
				<img src="/images/icons/amex.png">
				<img src="/images/icons/visa.png">
				<img src="/images/icons/discover.png">
			</div>
		</a>
	</li>
	<li role="presentation" class="contact-tabs__item">
		<a class="contact-tabs__link" href="#general" aria-controls="general" role="tab" data-toggle="tab">
			<div class="paypal">
				<img src="/images/icons/paypal.png">
			</div>
		</a>
	</li>
</ul>
<div class="tab-content">
	<div role="tabpanel" class="tab-pane fade in active" id="cc">
		<form id="credit-card-form" class="payment__form" method="post" action="<?php echo e(route('payment_cc')); ?>">
			<?php echo e(csrf_field()); ?>

			<h2 class="payment__title">Your information</h2>
			<div class="row">
				<div class="col-md-6">

					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<h3 class="payment-form__title"></h3>
								<label for="cc_fname" class="payment-form__label<?php echo e(!is_null(old('fname'))?' payment-form__label--jump':''); ?>">First name</label>
								<input id="cc_fname" name="fname" type="text" class="form-control payment-form__input" required>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<h3 class="payment-form__title"></h3>
								<label for="cc_lname" class="payment-form__label<?php echo e(!is_null(old('lname'))?' payment-form__label--jump':''); ?>">Last name</label>
								<input id="cc_lname" name="lname" type="text" class="form-control payment-form__input" required>
							</div>
						</div>
					</div>

					<div class="form-group">
						<h3 class="payment-form__title"></h3>
						<label for="card" class="payment-form__label<?php echo e(!is_null(old('number'))?' payment-form__label--jump':''); ?>">Card number</label>
						<input id="card" name="number" type="text" class="form-control payment-form__input" required>
					</div>
				</div>
				<div class="col-md-6">

					<div class="form-group">
						<h3 class="payment-form__title"></h3>
						<label for="cc_email" class="payment-form__label<?php echo e(!is_null(old('email'))?' payment-form__label--jump':''); ?>">Email address</label>
						<input id="cc_email" name="email" type="text" class="form-control payment-form__input" required>
					</div>
					<div class="row">
						<div class="col-xs-4">
							<div class="form-group">
								<h3 class="payment-form__title"></h3>
								<label for="Month" class="payment-form__label">Month</label>
								<select id="Month" name="month" class="form-control payment-form__input" required>
									<option label=" "></option>
									<option>01</option>
									<option>02</option>
									<option>03</option>
									<option>04</option>
									<option>05</option>
									<option>06</option>
									<option>07</option>
									<option>08</option>
									<option>09</option>
									<option>10</option>
									<option>11</option>
									<option>12</option>
								</select>
							</div>
						</div>
						<div class="col-xs-4">
							<div class="form-group">
								<h3 class="payment-form__title"></h3>
								<label for="year" class="payment-form__label">year</label>
								<select id="year" name="year" class="form-control payment-form__input" required>
									<option label=" "></option>
									<?php for($i = date('Y')+11; $i >= date('Y'); $i--): ?>
									<option><?php echo e($i); ?></option>
									<?php endfor; ?>
								</select>
							</div>
						</div>
						<div class="col-xs-4">
							<div class="form-group">
								<h3 class="payment-form__title"></h3>
								<label for="cvv" class="payment-form__label<?php echo e(!is_null(old('cvv'))?' payment-form__label--jump':''); ?>">cvv</label>
								<input id="cvv" name="cvv" type="text" class="form-control payment-form__input" required>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-4">
					<a class="order__back" href="<?php echo e(route('cart')); ?>">Back to cart</a>
				</div>
				<div class="col-sm-4"><span class="order__total">Total: $<?php echo e($cart_sum); ?>.00</span></div>
				<div class="col-sm-4">
					<div class="order__submit">
						<button class="btn btn-red" type="submit">Pay now</button>
					</div>
				</div>
			</div>
		</form>
	</div>
	<div role="tabpanel" class="tab-pane fade" id="general">
		<form class="payment__form" method="post" action="<?php echo e(route('payment_pp')); ?>">
			<?php echo e(csrf_field()); ?>

			<h2 class="payment__title">Your information</h2>
			<div class="row">
				<div class="col-sm-3">
					<div class="form-group">
						<h3 class="payment-form__title"></h3>
						<label for="pp_fname" class="payment-form__label">First name</label>
						<input id="pp_fname" name="fname" type="text" class="form-control payment-form__input" required>
					</div>
				</div>
				<div class="col-sm-3">
					<div class="form-group">
						<h3 class="payment-form__title"></h3>
						<label for="pp_lname" class="payment-form__label">Last name</label>
						<input id="pp_lname" name="lname" type="text" class="form-control payment-form__input" required>
					</div>
				</div>
				<div class="col-sm-6">	  
					<div class="form-group">
						<h3 class="payment-form__title"></h3>
						<label for="pp_email" class="payment-form__label">Email address</label>
						<input id="pp_email" name="email" type="text" class="form-control payment-form__input" required>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-4">
					<a class="order__back" href="<?php echo e(route('cart')); ?>">Back to cart</a>
				</div>
				<div class="col-sm-4"><span class="order__total">Total: $<?php echo e($cart_sum); ?>.00</span></div>
				<div class="col-sm-4">
					<div class="order__submit">
						<button class="btn btn-red" type="submit">Pay now</button>
					</div>
				</div>
			</div>
		</form>
	</div>
</div>

<?php $__env->startSection('scripts'); ?>
##parent-placeholder-16728d18790deb58b3b8c1df74f06e536b532695##
<script>
$(document).ready(function() {
	if ($('#pp_email').val()) {
		checkEmailAndMark($('#pp_email'));
	}
	$('#pp_email').on('input', function() {
		checkEmailAndMark($(this));
	});
	if ($('#cc_email').val()) {
		checkEmailAndMark($('#cc_email'));
	}
	$('#cc_email').on('input', function() {
		checkEmailAndMark($(this));
	});

	checkEmailAndMark($('#pp_email'));
	$('#pp_email').on('input', function() {
		checkEmailAndMark($(this));
	});

	checkCardAndMark($('#card'));
	$('#card').on('input', function() {
		checkCardAndMark($(this));
	});
	
	checkCvvAndMark($('#cvv'));
	$('#cvv').on('input', function() {
		markDefault($(this));
		checkCvvAndMark($(this));
	});
	$('input,select').each(function(index, elem) {
		var id = $(elem).attr('id');
		if (typeof id !== 'undefined' && $(elem).val() != '') {
			$('label[for="'+id+'"]').addClass('payment-form__label--jump');
		}
	});
	$('#credit-card-form').on('submit', function() {
		if (
			$('#cc_fname').val() !== ''
			&& $('#cc_lname').val() !== ''
			&& checkCard($('#card')) 
			&& $('#month').val() !== ''
			&& $('#year').val() !== ''
			&& checkCvv($('#cvv')) 
			&& checkEmail($('#cc_email'))
		) {
			if ($('#cc_fname').val() == '') {
				markError($('#cc_fname'))
			}
			if ($('#cc_lname').val() == '') {
				markError($('#cc_lname'))
			}
			if ($('#cvv').val() == '') {
				markError($('#cvv'))
			}
			return true;
		}
		return false;
	});
	
	$('#paypal-form').on('submit', function() {
		if (
			$('#pp_fname').val() !== ''
			&& $('#pp_lname').val() !== ''
			&& checkEmail($('#pp_email'))
		) {
			if ($('#pp_fname').val() == '') {
				markError($('#pp_fname'))
			}
			if ($('#pp_lname').val() == '') {
				markError($('#pp_lname'))
			}
			return true;
		}
		return false;
	});
});
function checkEmailAndMark($input) {
	if (checkEmail($input)) {
		markOk($input);
	} else {
		markError($input);
	}
}
function checkEmail($input) {
	var emailRegEx = /^[\w\d%$:.-]+@\w+\.\w{2,5}$/;
	return emailRegEx.test($input.val());
}
function checkCvv($input) {
	var cvvRegEx = /^\d{3,4}$/;
	if (!cvvRegEx.test($input.val())) {
		return false;
	}
	var card_first = $('#card').val().slice(0,1);
	var right_length = 3;
	switch (card_first) {
		case '3': {
			right_length = 4;
		} break;
		case '4':
		case '5':
		case '6':
			break;
		default: 
			return false;
	}
	if ($input.val().length === right_length) {
		return true;
	} else {
		return false;
	}
}
function checkCvvAndMark($input) {
	if (checkCard($('#card'))) {
		if (checkCvv($input)) {
			markOk($input);
		} else {
			markError($input);
		}
	} else {
		markError($('#card'));
	}
}
function checkCardAndMark($input) {
	if (checkCard($input)) {
		markOk($input);
	} else {
		markError($input);
	}
}
function checkCard($input) {
	var val = $input.val();
	var cardRegEx = /^\d{15,16}$/;
	if (!cardRegEx.test(val)) {
		return false;
	}
	var is_amex = false;
	var first = val.slice(0,1);
	if (val.length > 1) {
		switch (first) {
			case '3':
				is_amex = true;
			case '4':
			case '5':
			case '6':
				break;
			default:
				return false;
		}
	} else {
		return false;
	}
	if ((is_amex && val.length == 15) || (!is_amex && val.length == 16)) {
		return true;
	} else {
		return false;
	}
}
function markError($input) {
	if ($input.val()) {
		$input.css('border-bottom', '2px solid red');
	} else {
		markDefault($input);
	}
}
function markOk($input) {
	if ($input.val()) {
		$input.css('border-bottom', '2px solid green');
	} else {
		markDefault($input);
	}
}
function markDefault($input) {
	$input.css('border-bottom', '1px inherit inherit');
}
</script>
<?php $__env->stopSection(); ?>